class OrderInfo extends HTMLElement {
  async connectedCallback() {
    const orderId = this.getAttribute('order-id');

    this.isLoading = true;
    this.order = null;

    this.renderComponent();

    try {
      const where = this.isAnonymous()
        ? `id="${orderId}"`
        : `id="${orderId}" and customerId="[current_customer:id]"`;

      const response = await window.commercetools.getOrders({ where }, true);

      [this.order] = response.orders;

      if (!this.order) {
        this.renderNotFound();
      }
    } finally {
      this.isLoading = false;
      this.renderComponent();
    }
  }

  renderNotFound() {
    this.innerHTML = '';
    const notFound = document.createElement('ct-page-not-found');
    this.appendChild(notFound);
  }

  renderComponent() {
    const container = document.createElement('ct-order-details');
    container.isLoading = this.isLoading;
    container.order = this.order;
    this.innerHTML = '';
    this.appendChild(container);
  }

  // eslint-disable-next-line class-methods-use-this
  isAnonymous() {
    return drupalSettings.user.uid === 0;
  }
}

customElements.define('ct-order-info', OrderInfo);
