<?php

declare(strict_types=1);

namespace Drupal\commercetools_decoupled\Plugin\Block;

use Drupal\commercetools\Plugin\Block\CommercetoolsCategoriesListBlockBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a Categories List block.
 *
 * @Block(
 *   id = "commercetools_decoupled_categories_list",
 *   admin_label = @Translation("Categories"),
 * )
 */
class CommercetoolsDecoupledCategoriesListBlock extends CommercetoolsCategoriesListBlockBase {

  /**
   * Commercetools Decoupled main service.
   *
   * @var \Drupal\commercetools_decoupled\CommercetoolsDecoupled
   */
  protected $ctDecoupled;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
    $instance->ctDecoupled = $container->get('commercetools_decoupled');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function buildSafe(): array {
    $config = $this->getConfiguration();
    $displayStyle = $config['display_style'];
    if (empty($config['product_list_index'])) {
      $config['product_list_index'] = 0;
    }
    return $this->ctDecoupled->addDecoupledSettings([
      '#type' => 'component',
      '#component' => "commercetools_decoupled:categories-{$displayStyle}-block",
      '#props' => $config,
      '#attributes' => [
        'class' => ["ct-categories-{$displayStyle}-block"],
      ],
    ]);
  }

}
