<?php

declare(strict_types=1);

namespace Drupal\commercetools_decoupled\Plugin\Block;

use Drupal\commercetools\Plugin\Block\CommercetoolsProductFiltersBlockBase;
use Drupal\commercetools_decoupled\CommercetoolsDecoupled;
use Symfony\Component\DependencyInjection\ContainerInterface;

use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a product filters block.
 *
 * @Block(
 *   id = "commercetools_decoupled_product_filters",
 *   admin_label = @Translation("Product Filters"),
 * )
 */
class CommercetoolsDecoupledProductFiltersBlock extends CommercetoolsProductFiltersBlockBase {

  /**
   * Commercetools Decoupled main service.
   *
   * @var \Drupal\commercetools_decoupled\CommercetoolsDecoupled
   */
  protected CommercetoolsDecoupled $ctDecoupled;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
    $instance->ctDecoupled = $container->get('commercetools_decoupled');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return parent::defaultConfiguration() + [
      'use_ajax_autosubmit' => TRUE,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function blockForm($form, FormStateInterface $form_state): array {
    $form = parent::blockForm($form, $form_state);

    $form['use_ajax_autosubmit'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Enable autosubmit'),
      '#default_value' => $this->configuration['use_ajax_autosubmit'],
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function blockSubmit($form, FormStateInterface $form_state): void {
    parent::blockSubmit($form, $form_state);
    $this->configuration['use_ajax_autosubmit'] = $form_state->getValue('use_ajax_autosubmit');
  }

  /**
   * {@inheritdoc}
   */
  public function buildSafe(): array {
    $configuration = $this->getConfiguration();

    if (empty($configuration['product_list_index'])) {
      $configuration['product_list_index'] = 0;
    }

    $configuration['filters'] = $this->getEnabledFilters();

    return $this->ctDecoupled->addDecoupledSettings([
      '#type' => 'component',
      '#component' => 'commercetools_decoupled:filters-block',
      '#props' => $configuration,
    ]);
  }

}
