<?php

declare(strict_types=1);

namespace Drupal\commercetools_decoupled\Plugin\Block;

use Drupal\commercetools\CommercetoolsService;
use Drupal\commercetools\Plugin\Block\CommercetoolsProductListBlockBase;
use Drupal\commercetools_decoupled\CommercetoolsDecoupled;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a product list block.
 *
 * @Block(
 *   id = "commercetools_decoupled_product_list",
 *   admin_label = @Translation("Product List"),
 * )
 */
class CommercetoolsDecoupledProductListBlock extends CommercetoolsProductListBlockBase {

  /**
   * Commercetools Decoupled main service.
   *
   * @var \Drupal\commercetools_decoupled\CommercetoolsDecoupled
   */
  protected CommercetoolsDecoupled $ctDecoupled;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): static {
    $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
    $instance->ctDecoupled = $container->get('commercetools_decoupled');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function buildSafe(): array {
    $config = $this->getConfiguration();
    if (empty($config['product_list_index'])) {
      $config['product_list_index'] = 0;
    }
    $itemsPerPage = isset($this->configuration['items_per_page']) && !empty($this->configuration['items_per_page'])
      ? (int) $this->configuration['items_per_page']
      : (int) $this->configFactory
        ->get(CommercetoolsService::CONFIGURATION_NAME)
        ->get(CommercetoolsService::CONFIG_ITEMS_PER_PAGE);

    $config['product_list_index'] = (int) $config['product_list_index'];
    $config['items_per_page'] = $itemsPerPage;
    $config['total_limit'] = (int) $config['total_limit'];
    $config['columns_number'] = (int) $config['columns_number'];
    return $this->ctDecoupled->addDecoupledSettings([
      '#type' => 'component',
      '#component' => 'commercetools_decoupled:products-list',
      '#props' => $config,
    ]);
  }

}
