<?php

namespace Drupal\commercetools_demo\Plugin\Block;

use Drupal\Core\Language\LanguageInterface;
use Drupal\Core\Template\Attribute;
use Drupal\language\Plugin\Block\LanguageBlock;

/**
 * Provides a locale switcher block for commercetools demo.
 *
 * @Block(
 *   id = "commercetools_demo_locale_switcher",
 *   admin_label = @Translation("Locale switcher"),
 * )
 */
class LocaleSwitcher extends LanguageBlock {

  /**
   * {@inheritdoc}
   */
  public function build() {
    $build = parent::build();
    $links = $build['#links'];
    $current_lid = $this->languageManager->getCurrentLanguage(LanguageInterface::TYPE_CONTENT)->getId();
    $native_names = $this->languageManager->getStandardLanguageList();
    $header = $this->t('Select locale');

    // Place active language to header.
    if (isset($links[$current_lid])) {
      $header = $links[$current_lid]['title'];
      unset($links[$current_lid]);
    }

    foreach ($links as $lid => $link) {
      $name = $link['title'] ?? NULL;
      $nativeName = empty($native_names[$lid]) ? NULL : end($native_names[$lid]);
      if ($nativeName && $nativeName != $name) {
        $link['attributes']['title'] = $nativeName;
      }
      /** @var \Drupal\Core\Url $url */
      $url = $link['url'];
      $query = $link['query'];
      unset($query['language_content_entity']);
      $url->setOptions([
        'query' => $query,
        'language' => $this->languageManager->getLanguage($lid),
      ]);
      $url->setAbsolute();
      $links[$lid]['href'] = $url->toString();
      $links[$lid]['attributes'] = new Attribute($link['attributes']);
    }

    return [
      '#theme' => 'commercetools_locales_block__demo',
      '#header' => $header,
      '#links' => $links,
    ];
  }

}
