/**
 * Converts absolute url to relative.
 *
 * @param {string} fullUrl
 *   Nightwatch browser instance.
 * @return {object} Url
 *   Clean URL objects.
 */
function getRelativeUrl(fullUrl) {
  const baseUrl = process.env.DRUPAL_TEST_BASE_URL;

  const relativePath = fullUrl.replace(baseUrl, '');

  const resolvedBase = new URL(fullUrl).origin;

  return new URL(relativePath, resolvedBase).href;
}

module.exports = getRelativeUrl;
