// eslint-disable-next-line import/no-extraneous-dependencies
const YAML = require('yaml');
const fs = require('fs');
const path = require('path');

/**
 * Load all YAML files from a specified directory dynamically based on account name.
 *
 * @param {string} accountName - The name of the account (e.g., 'b2c_lifestyle').
 * @return {object[]} Array of parsed YAML content from all files in the directory.
 * @throws {Error} If the directory or files are not found or unreadable.
 */
function loadYamlFiles(accountName) {
  const directoryPath = path.join(
    __dirname,
    `../../../../../fixtures/demo_accounts/${accountName}/block_content`,
  );

  // Ensure the directory exists
  if (!fs.existsSync(directoryPath)) {
    throw new Error(`Directory not found: ${directoryPath}`);
  }

  // Read all files in the directory
  const files = fs.readdirSync(directoryPath);

  const yamlFiles = files.filter((file) => file.endsWith('.yml'));

  // Parse each YAML file in the directory
  const parsedYaml = yamlFiles.map((file) => {
    const filePath = path.join(directoryPath, file);
    const fileContents = fs.readFileSync(filePath, 'utf8');
    return YAML.parse(fileContents);
  });

  return parsedYaml;
}

module.exports = loadYamlFiles;
