/**
 * Checks that uninstall of extension works well and cleanup created entities.
 *
 * @param {object} browser
 *   Nightwatch browser instance.
 */
module.exports = async function checkDemoCleanup(browser) {
  await browser.perform(async () => {
    await browser
      .drupalRelativeURL('/admin/modules/uninstall')
      .click(`input[name="uninstall[commercetools_demo_test]"]`)
      .submitForm('form.system-modules-uninstall')
      .submitForm('form.system-modules-uninstall-confirm-form')
      .assert.textContains(
        { selector: 'div[data-drupal-messages]' },
        'The selected modules have been uninstalled.',
      );
    await browser
      .drupalRelativeURL('/admin/modules/uninstall')
      .click(`input[name="uninstall[commercetools_demo]"]`)
      .submitForm('form.system-modules-uninstall')
      .submitForm('form.system-modules-uninstall-confirm-form')
      .assert.textContains(
        { selector: 'div[data-drupal-messages]' },
        'The selected modules have been uninstalled.',
      );
    await browser
      .drupalRelativeURL('/admin/modules')
      .click(`input[name="modules[commercetools_demo][enable]"`)
      .submitForm('form.system-modules')
      .assert.textContains(
        { selector: 'div[data-drupal-messages]' },
        'The Commercetools Demo module is ready.',
      );
  });
};
