const loadYamlFiles = require('./Utils/loadYamlFiles');
const getRelativeUrl = require('./Utils/getRelativeUrl');

module.exports = async function checkDemoProductsPage(browser, accountName) {
  const commercetoolsTestBlocks = loadYamlFiles(accountName);
  const blockClassName = '.block-inline-blockcommercetools-demo';
  const blockProductsFilter = `.block-${browser.globals.ct.testingModuleName.replace(/_/g, '-')}-product-filters`;

  browser
    .thLogin('admin')
    .drupalRelativeURL('/admin/config/system/commercetools/demo');

  browser.perform(async () => {
    browser.globals.ct.articleUrl = await browser.getAttribute(
      'link text',
      'View demo article',
      'href',
    );

    const demoArticleUrl = getRelativeUrl(browser.globals.ct.articleUrl);

    await browser
      .url(demoArticleUrl)
      .waitForElementVisible(
        '.commercetools-product-cards:not(.placeholderify)',
      )
      .assert.visible(
        '.commercetools-product-cards',
        'Product cards container is visible',
      )
      .assert.elementCount(
        '.commercetools-product-cards .card',
        6,
        'There are exactly 6 product cards on the page',
      );

    await browser
      .url(demoArticleUrl)
      .waitForElementVisible(blockProductsFilter)
      .assert.visible(
        blockProductsFilter,
        'Product filters container is visible',
      );

    await browser.url(demoArticleUrl).perform(async () => {
      const count = await browser.elements(
        'css selector',
        blockClassName,
        function checkBlocksCount(result) {
          // Ensure the number of blocks matches the expected titles count
          browser.assert.equal(
            result.value.length,
            commercetoolsTestBlocks.length,
            `Expected ${commercetoolsTestBlocks.length} blocks but found ${result.value.length}`,
          );
          return result.value.length;
        },
      );
      // We have to use await in the loop.
      for (let i = 0; i < count; i++) {
        /* eslint-disable-next-line no-await-in-loop */
        const headingText = await browser.getText(
          browser
            .element({ selector: blockClassName, index: i })
            .findElement('h2'),
        );
        /* eslint-disable-next-line no-await-in-loop */
        await browser.perform(() => {
          browser.assert.equal(
            headingText,
            commercetoolsTestBlocks[i].default.info[0].value,
            `Block ${i + 1} has the correct title: ${headingText}`,
          );
        });

        // Checks for body.
        // eslint-disable-next-line no-await-in-loop
        const bodyText = await browser.getText(
          browser
            .element({ selector: blockClassName, index: i })
            .findElement('.field-body p'),
        );
        /* eslint-disable-next-line no-await-in-loop */
        await browser.perform(() => {
          browser.assert.equal(
            bodyText,
            commercetoolsTestBlocks[i].default.body[0].value,
            `Block ${i + 1} has the correct body: ${bodyText}`,
          );
        });
      }
    });
  });

  return browser;
};
