const shopSmokeTest = require('../../../../../../tests/src/Nightwatch/Lib/shopSmokeTest');
const deployDemoModule = require('./deployDemoModule');
const checkDemoProductsPage = require('./checkDemoProductsPage');
const checkDemoCleanup = require('./checkDemoCleanup');

/**
 * Performs a smoke test for the demo functionality.
 *
 * @param {object} browser
 *   Nightwatch browser instance.
 */
module.exports = function smokeTestDemo(browser) {
  let catalogPrefix;
  if (browser.globals.ct.testingModuleName === 'commercetools_content') {
    catalogPrefix = 'content';
  } else if (
    browser.globals.ct.testingModuleName === 'commercetools_decoupled'
  ) {
    catalogPrefix = 'decoupled';
  } else {
    throw new Error(`Unknown module: ${browser.globals.ct.testingModuleName}`);
  }
  const catalogPath = `/commercetools-demo/${catalogPrefix}/catalog`;
  browser.perform(async () => {
    await deployDemoModule(browser);
    await shopSmokeTest(browser, catalogPath);
    await checkDemoProductsPage(browser, 'demo1_b2c_lifestyle');
    // Uninstall pages
    await browser
      .thLogin('admin')
      .drupalRelativeURL('/admin/config/system/commercetools/demo')
      .click(`input[name=uninstall_${browser.globals.ct.testingModuleName}]`);
  });
  browser.perform(async () => {
    await browser
      .drupalRelativeURL('/admin/config/system/commercetools/demo')
      .click(`input[name=set_demo_credentials_demo2_b2b_machinery]`)
      .assert.textContains(
        'body',
        'demo credentials, project - Drupal Demo: Heavy Machinery (B2B)',
      );

    await browser
      .click(`input[name=install_${browser.globals.ct.testingModuleName}]`)
      .assert.textContains('body', 'Installed with demo configuration');
  });
  browser.perform(async () => {
    await checkDemoProductsPage(browser, 'demo2_b2b_machinery');
  });
  browser.perform(async () => {
    // await checkDemoCleanup(browser);
  });
};
