<?php

namespace Drupal\commercetools\Controller;

use Drupal\commercetools\CommercetoolsApiServiceInterface;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Defines a controller for the Commercetools summary page.
 */
class SummaryController extends ControllerBase {

  /**
   * The Commercetools service.
   *
   * @var \Drupal\commercetools\CommercetoolsApiServiceInterface
   */
  protected CommercetoolsApiServiceInterface $ctApi;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = parent::create($container);
    $instance->ctApi = $container->get('commercetools.api');
    return $instance;
  }

  /**
   * Displays a page with the project summary info from Commercetools.
   */
  public function view(): array {
    $info = $this->ctApi->getProjectInfo();
    return [
      '#theme' => 'commercetools_summary',
      '#project_settings' => $info,
    ];
  }

}
