<?php

namespace Drupal\commercetools\Event;

use Drupal\Component\EventDispatcher\Event;

/**
 * Provides a Commercetools message event for event listeners.
 */
class CommercetoolsMessageEvent extends Event {

  /**
   * Constructs the object.
   *
   * @param array $message
   *   Commercetools message data.
   */
  public function __construct(
    protected array $message,
  ) {
  }

  /**
   * Returns the message data from the event.
   *
   * @return array
   *   The Commercetools Message data.
   */
  public function getMessage() {
    return $this->message;
  }

}
