<?php

namespace Drupal\commercetools\Exception;

/**
 * Exception thrown when the Commercetools module has no configured credentials.
 */
class CommercetoolsMissingPermissionException extends CommercetoolsOperationFailedException {

  /**
   * {@inheritdoc}
   */
  public function __construct(?string $message = NULL, int $code = 0, ?\Throwable $previous = NULL) {
    $message ??= "The commercetools API responds with the forbidden error using the configured credentials. Check the client permissions in the commercetools Merchant Center.";
    parent::__construct($message, $code, $previous);
  }

}
