<?php

namespace Drupal\commercetools\Form;

use Drupal\commercetools\CommercetoolsService;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Routing\RouteBuilderInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Configure a Commercetools settings form for this site.
 */
abstract class UiModuleSettingsFormBase extends CommercetoolsSettingsFormBase {
  const CONFIGURATION_NAME = '';
  const CONFIG_CATALOG_PATH = 'catalog_path';
  const CONFIG_CART_PATH = 'cart_path';
  const CONFIG_USER_ORDERS_PATH = 'user_orders_path';
  const CONFIG_CHECKOUT_PATH = 'checkout_path';

  /**
   * The Commercetools service.
   *
   * @var \Drupal\commercetools\CommercetoolsService
   */
  protected CommercetoolsService $ct;

  /**
   * The route builder.
   *
   * @var \Drupal\Core\Routing\RouteBuilderInterface
   */
  protected RouteBuilderInterface $routeBuilder;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    $instance = parent::create($container);
    $instance->routeBuilder = $container->get('router.builder');
    $instance->ct = $container->get('commercetools');
    return $instance;
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form[self::CONFIG_CATALOG_PATH] = $this->getFormElement(self::CONFIG_CATALOG_PATH, [
      '#description' => $this->t('Relative path to the product catalog page. Example: "/catalog".'),
    ]);
    $form[self::CONFIG_CART_PATH] = $this->getFormElement(self::CONFIG_CART_PATH, [
      '#description' => $this->t('Relative path prefix for the user\'s cart page. Example: "/cart".'),
    ]);
    $form[self::CONFIG_USER_ORDERS_PATH] = $this->getFormElement(self::CONFIG_USER_ORDERS_PATH, [
      '#description' => $this->t('Relative path to display a user\'s orders. The path should contain "{user}". Example: "/user/{user}/orders"'),
    ]);
    $form[self::CONFIG_CHECKOUT_PATH] = $this->getFormElement(self::CONFIG_CHECKOUT_PATH, [
      '#description' => $this->t('Relative path for the checkout page. Example: "/checkout".'),
    ]);
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);
    $this->routeBuilder->rebuild();
  }

}
