<?php

namespace Drupal\commercetools\Plugin\commercetools\SubscriptionDestinationType;

use Drupal\commercetools\Attribute\SubscriptionDestinationType;
use Drupal\commercetools\Form\SubscriptionSettingsForm;
use Drupal\commercetools\SubscriptionDestinationTypeBase;
use Drupal\Core\Render\Element\Password;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Provides a AWS SQS subscription.
 *
 * @SubscriptionDestinationType(
 *   id = "sqs",
 *   label = @Translation("AWS SQS"),
 *   config_name = "commercetools.subscriptions_destination_sqs",
 * )
 */
#[SubscriptionDestinationType(
  id: "sqs",
  label: new TranslatableMarkup('AWS SQS'),
  config_name: "commercetools.subscriptions_destination_sqs",
)]
class SqsSubscriptionDestination extends SubscriptionDestinationTypeBase {

  /**
   * {@inheritdoc}
   */
  public function getSettingsFormFields(): array {
    $fields = [];

    $fields['queue_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Queue URL'),
      '#required' => TRUE,
      '#size' => 120,
    ];
    $fields['access_key'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Access Key'),
      '#required' => TRUE,
    ];
    $fields['access_secret'] = [
      '#type' => 'password',
      '#title' => $this->t('Access Secret'),
      '#required' => TRUE,
      '#pre_render' => [
        [Password::class, 'preRenderPassword'],
        // A trick to prefill the stored secret value.
        [SubscriptionSettingsForm::class, 'fillStoredPasswordCallback'],
      ],
    ];
    $fields['region'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Region'),
      '#required' => TRUE,
    ];

    return $fields;
  }

  /**
   * {@inheritdoc}
   */
  public function getDestinationQueryPart(array $formValues): array {
    $filedNames = [
      'queue_url' => 'queueUrl',
      'access_key' => 'accessKey',
      'access_secret' => 'accessSecret',
      'region' => 'region',
    ];

    $result = [];
    foreach ($filedNames as $fieldNameForm => $fieldNameQuery) {
      if (!empty($formValues[$fieldNameForm])) {
        $result[$fieldNameQuery] = $formValues[$fieldNameForm];
      }
    }
    $result['authenticationMode'] = 'Credentials';
    return $result;
  }

  /**
   * {@inheritdoc}
   */
  public function getDestinationQueryName(): string {
    return 'SQS';
  }

}
