<?php

namespace Drupal\commercetools;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Base class for subscription destination plugins.
 *
 * @see \Drupal\commercetools\SubscriptionDestinationTypeInterface
 */
abstract class SubscriptionDestinationTypeBase extends PluginBase implements SubscriptionDestinationTypeInterface {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function label(): string {
    return $this->pluginDefinition['label'];
  }

  /**
   * {@inheritdoc}
   */
  public function getConfigName(): string {
    return $this->pluginDefinition['config_name'];
  }

}
