<?php

namespace Drupal\commercetools;

/**
 * Contract for commercetools subscription destinations.
 *
 * For example SQS, GoogleCloudPubSub.
 */
interface SubscriptionDestinationTypeInterface {

  /**
   * Human-readable label of the destination (for UI).
   *
   * @return string
   *   The destination label.
   */
  public function label(): string;

  /**
   * Form API elements to configure this destination.
   *
   * @return array
   *   A render array with settings fields.
   */
  public function getSettingsFormFields(): array;

  /**
   * Builds the GraphQL subscription destination payload from form values.
   *
   * @param array $formValues
   *   Submitted values relevant to this destination.
   *
   * @return array
   *   The destination part of the draft/request.
   */
  public function getDestinationQueryPart(array $formValues): array;

  /**
   * GraphQL destination discriminator key (e.g., "SQS").
   *
   * @return string
   *   The destination query name.
   */
  public function getDestinationQueryName(): string;

  /**
   * The config name.
   *
   * @return string
   *   The config name.
   */
  public function getConfigName(): string;

}
