<?php

declare(strict_types=1);

namespace Drupal\commercetools_test;

use Drupal\test_helpers\Stub\HttpClientFactoryStub;

/**
 * Overridden version of the HttpClientFactoryStub.
 */
class CommercetoolsHttpClientFactoryStub extends HttpClientFactoryStub {

  /**
   * Extends the parent to format the stored requests for commercetools testing.
   *
   * {@inheritdoc}
   */
  protected function stubGetRequestMetadata($request): array {
    $metadata = parent::stubGetRequestMetadata($request);
    $metadata = CommerceToolsTesting::formatCtRequestAssetMetadata($metadata);
    return $metadata;
  }

}
