const addCatalogProductToCart = require('./utils/addCatalogProductToCart');
const checkSummaryLineItem = require('./checkSummaryLineItem');
const { blocks, product } = require('./selectors');
const checkInStockFilter = require('./checkInStockFilter');

async function checkCartSummaryBlock(browser, items, catalogUrl, settings) {
  // Save old cookies to restore after checking the Cart Summary block.
  const oldCookies = await browser.cookies.getAll();
  const cardInStockIndex = 0;

  browser
    .drupalRelativeURL(catalogUrl)
    .waitForElementVisible(product.catalog)
    .perform(() => {
      checkInStockFilter(browser);
    })
    // Add a product to the cart.
    .perform(async () => {
      await addCatalogProductToCart(browser, cardInStockIndex);
    })
    // Open dropdown of the Cart Summary block.
    .drupalRelativeURL(catalogUrl)
    .waitForElementVisible(product.catalog)
    .waitForElementVisible(blocks.summary.component)
    .waitForElementVisible(blocks.summary.dropdownButton)
    .click(
      browser
        .element({ selector: blocks.summary.component })
        .findElement(blocks.summary.dropdownButton),
    )
    .perform(async () => {
      await browser.waitForElementVisible(
        browser
          .element({ selector: blocks.summary.component })
          .findElement(blocks.summary.dropdown),
      );
    })
    // Check dropdown with line items.
    .perform(async () => {
      await checkSummaryLineItem(browser, items[cardInStockIndex], 0, settings);
    })
    // Delete new cookies created after adding an item to the cart.
    .perform(async () => {
      const cookies = await browser.cookies.getAll();
      cookies.forEach((cookie) => {
        if (!oldCookies.some((oldCookie) => cookie.name === oldCookie.name)) {
          browser.cookies.delete(cookie.name);
        }
      });
    });
}

module.exports = checkCartSummaryBlock;
