const {
  product: { card },
} = require('./selectors');
const getResponseFromLatestByDataType = require('./getResponseFromLatestByDataType');
const setMockMode = require('./setMockMode');
const unsetMockMode = require('./unsetMockMode');
const commerceToolsConfigs = require('./commerceToolsConfigs');

module.exports = function checkCatalogPageCaching(browser, module) {
  const path = commerceToolsConfigs[module][`${module}.settings`].catalog_path;

  const titleMocked = 'Product Title Mocked';
  const dataType = 'productProjectionSearch';
  browser.perform(async () => {
    const titleActual = await browser
      .drupalRelativeURL(path)
      .waitForElementVisible(card.component)
      .getText(card.title);

    const storedResponse = await getResponseFromLatestByDataType(
      browser,
      dataType,
    );
    const titleFromApi = storedResponse.value.data[dataType].results[0].name;
    await browser.assert.equal(titleActual, titleFromApi);

    // Modifying the mocked response.
    const mockedResponseData = JSON.parse(JSON.stringify(storedResponse.value));
    mockedResponseData.data[dataType].results[0].name = titleMocked;
    await browser.thSetRequestResponseByHash(
      storedResponse.hash,
      JSON.stringify(mockedResponseData),
    );
    setMockMode(browser);

    // Checking if the page content is properly cached - we should see the
    // cached content.
    await browser
      .drupalRelativeURL(path)
      .waitForElementVisible(card.component)
      .assert.textEquals(card.title, titleFromApi)

      // Checking if the GraphQL response is properly cached.
      .drupalRelativeURL(`${path}?foo=bar`)
      .waitForElementVisible(card.component)
      .assert.textEquals(card.title, titleFromApi)

      // Simulate the Commercetools message to invalidate the current product.
      .thDrupalFetchURL(
        '/commercetools-test/message-invalidate-product/some-product-id',
      )

      // Do cache clear here.
      .drupalRelativeURL(path)
      .waitForElementVisible(card.component)
      .assert.textEquals(card.title, titleMocked)

      // Reverting the stored response back to the original state.
      .thSetRequestResponseByHash(
        storedResponse.hash,
        JSON.stringify(storedResponse.value),
      );
    unsetMockMode(browser);
  });
};
