const selectors = require('./selectors');

module.exports = function checkFacets(browser, productListItems) {
  if (productListItems.length === 0) {
    return;
  }

  let facetValueForAssertion;
  let attributeMap;
  const locale = `${browser.globals.ct.locale.langcode}-${browser.globals.ct.locale.country}`;

  function getProductsAttributeMap(attributeName) {
    const getAttributeValue = (attr, locale) => {
      const value = attr?.value;
      if (value == null) return null;
      if (typeof value !== 'object') return String(value);
      if ('key' in value) return String(value.key);
      return String(value[locale] ?? Object.values(value)[0] ?? '');
    };
    return productListItems.map((product) => {
      const attribute = product.masterVariant.attributesRaw.find(
        (attr) => attr.name === attributeName,
      );
      const attributeValue = getAttributeValue(attribute, locale);
      return {
        name: product.name,
        attributeValue,
      };
    });
  }

  const clickFacetInput = (facetValue) => {
    browser.thPerformAndWaitForReRender(() => {
      browser
        .click({ selector: `input.facet-filter[value="${facetValue}"]` })
        .isVisible(selectors.blocks.filters.apply, (result) => {
          if (result.value) {
            browser.click({ selector: selectors.blocks.filters.apply });
          }
        });
    }, selectors.product.card.component);
  };

  browser
    .perform(async () => {
      const elements = await browser.elements(
        'css selector',
        '.commercetools-filters-form input.facet-filter',
      );
      // eslint-disable-next-line no-restricted-syntax
      for (const element of elements) {
        const idKey = Object.keys(element)[0];
        const elementId = element[idKey];
        // eslint-disable-next-line no-await-in-loop
        const attributeKey = await browser.elementIdAttribute(
          elementId,
          'data-product-attribute-key',
        );
        // eslint-disable-next-line no-await-in-loop
        const facetValue = await browser.elementIdAttribute(elementId, 'value');
        attributeMap = getProductsAttributeMap(attributeKey);
        const matchingItems = attributeMap.filter(
          (item) => item.attributeValue === facetValue,
        );
        const hasMatchingItems = matchingItems.length > 0;
        const hasOtherItems = attributeMap.some(
          (item) => item.attributeValue !== facetValue,
        );

        if (hasMatchingItems && hasOtherItems) {
          facetValueForAssertion = facetValue;
          break;
        }
      }
    })

    .perform(() => {
      // Perform filtering.
      clickFacetInput(facetValueForAssertion);
    })

    .perform(() => {
      attributeMap.forEach((product) => {
        if (product.attributeValue === facetValueForAssertion) {
          browser.assert.textContains(
            { selector: selectors.product.catalog },
            product.name,
          );
        } else {
          browser.expect
            .element(selectors.product.catalog)
            .text.to.not.contain(product.name);
        }
      });
    })

    .perform(() => {
      // Cancel filtering.
      clickFacetInput(facetValueForAssertion);
    });
};
