const {
  product,
  blocks: { filters },
} = require('./selectors');

module.exports = function checkInStockFilter(browser) {
  const performCheckInStockFilter = () => {
    browser.thPerformAndWaitForReRender(() => {
      browser
        .click({ selector: filters.inStockFilter })
        .isVisible(filters.apply, (result) => {
          if (result.value) {
            browser.click({ selector: filters.apply });
          }
        });
    }, product.card.component);
  };

  browser.perform(() => {
    performCheckInStockFilter();
  });
};
