const checkProductCard = require('./checkProductCard');
const checkEmptyProductList = require('./checkEmptyProductList');
const { product, blocks } = require('./selectors');

function checkSearchFrom(browser, items, settings) {
  const [first] = items;

  const performSearch = (
    searchValue,
    options = {
      expectNewProductList: false,
      expectNoProducts: false,
    },
  ) => {
    const resultSelector = options.expectNoProducts
      ? product.catalogNoProductsFound
      : product.cards;
    browser.perform(() => {
      browser
        .element({ selector: blocks.search.component })
        .findElement(blocks.search.input)
        .setValue(searchValue);
    });
    const action = () => {
      browser.click(
        browser
          .element({ selector: blocks.search.component })
          .findElement(blocks.search.submit),
      );
    };
    if (options.expectNewProductList) {
      browser
        .perform(() => {
          action();
        })
        .waitForElementVisible(resultSelector);
    } else {
      browser.thPerformAndWaitForReRender(action, resultSelector);
    }
  };

  browser
    // Search by the first value, there must be at least one result.
    .perform(() => {
      performSearch(first.name);
    })
    .perform(() => {
      checkProductCard(browser, first, 0, settings);
    })
    // Search for an unknown value, there should be no result.
    .perform(() => {
      performSearch('[commercetools_test_value]', {
        expectNewProductList: true,
        expectNoProducts: true,
      });
    })
    .perform(() => {
      checkEmptyProductList(browser);
    })
    // Return to the initial state, there must be at least one result.
    .perform(() => {
      performSearch('', { expectNewProductList: true });
    })
    .perform(() => {
      checkProductCard(browser, first, 0, settings);
    });
}

module.exports = checkSearchFrom;
