const { blocks } = require('./selectors');

const selectors = {
  image: `${blocks.summary.component} ${
    blocks.summary.dropdown
  } .line-items .row > div:nth-child(1) img`,
  name: `${blocks.summary.component} ${
    blocks.summary.dropdown
  } .line-items .row > div:nth-child(2) a`,
  price: `${blocks.summary.component} ${
    blocks.summary.dropdown
  } .line-items .row > div:nth-child(3) span`,
};

async function checkSummaryLineItem(browser, item, index, settings) {
  const nameEl = {
    selector: selectors.name,
    index,
  };

  const imageEl = {
    selector: selectors.image,
    index,
  };
  const priceEl = {
    selector: selectors.price,
    index,
  };

  const priceData = item.masterData
    ? item.masterData.current.masterVariant.price
    : item.masterVariant.price;

  // Perform assertions.
  await browser.assert
    .textContains(
      nameEl,
      item.masterData ? item.masterData.current.name : item.name,
      `Checking the product title of item ${index}`,
    )
    .assert.attributeEquals(
      imageEl,
      'src',
      item.masterData
        ? item.masterData.current.masterVariant.images[0].url
        : item.masterVariant.images[0].url,
      `Checking the product image of item ${index}`,
    );
  if (priceData && priceData.value) {
    await browser.assert.textContains(
      priceEl,
      new Intl.NumberFormat('en', {
        style: 'currency',
        currency: settings.currency,
      }).format(
        priceData.value.centAmount / 10 ** priceData.value.fractionDigits,
      ),
      `Checking the product price of item ${index}`,
    );
  }
}

module.exports = checkSummaryLineItem;
