const path = require('path');
// We need this package only for tests, so keeping it as devDependency.
// eslint-disable-next-line import/no-extraneous-dependencies
const i18n = require('gettext.js')();
// We need this package only for tests, so keeping it as devDependency.
// eslint-disable-next-line import/no-extraneous-dependencies
const po2json = require('@connectedcars/po2json');
const selectors = require('./selectors');
const commerceToolsConfigs = require('./commerceToolsConfigs');

function loadTranslations(lang) {
  const poFilePath = path.join(
    __dirname,
    `../../../../translations/${lang}.po`,
  );
  const poJson = po2json.parseFileSync(poFilePath, { format: 'mf' });
  // Adding language metadata, because it's required by Gettext.js.
  poJson[''] = {
    language: lang,
    'plural-forms': 'nplurals=2; plural=n>1;',
  };

  i18n.loadJSON(poJson);
  i18n.setLocale(lang);
}

module.exports = function checkTranslations(browser, module) {
  const languages = ['fr', 'de'];
  const catalogUrl =
    commerceToolsConfigs[module][`${module}.settings`].catalog_path;

  const addToCartText = 'Add to Cart';
  const detailsButtonText = 'Details';

  // Enforce localization auto-configuration.
  browser
    .thLogin('admin')
    .drupalRelativeURL('/admin/config/system/commercetools/store')
    .waitForElementVisible('body')
    .click('input#edit-submit[name=op]')
    .waitForElementVisible('body')
    .thLogout();

  languages.forEach((lang) => {
    loadTranslations(lang);
    browser
      .drupalRelativeURL(`/${lang}${catalogUrl}`)

      // Check the "Add to Cart" button translation on the product card.
      .waitForElementVisible(selectors.product.card.component)
      .assert.textEquals(
        selectors.product.card.addToCart,
        i18n.gettext(detailsButtonText),
      )

      // Check the "Add to Cart" button translation on the product page.
      .click(
        browser
          .element({
            selector: selectors.product.card.component,
          })
          .findElement(selectors.product.card.title),
      )
      .waitForElementVisible(selectors.product.page.component)
      .assert.valueEquals(
        selectors.product.page.addToCart,
        i18n.gettext(addToCartText),
      );
  });
};
