module.exports = {
  blocks: {
    search: {
      component: '.commercetools-product-search-form:not(.placeholderify)',
      input: 'input[type="text"]',
      submit: 'button[type="submit"]',
    },
    filters: {
      component:
        '.commercetools-filters-form:not(.placeholderify):not(.reloadify)',
      inStockFilter:
        '.filters-variants-availability-is-on-stock input[type="checkbox"]',
      apply: '.button[value="Apply"]',
    },
    summary: {
      component: '.commercetools-summary-block:not(.placeholderify)',
      dropdownButton: 'button#cartDropdown',
      dropdown: '.dropdown-menu',
    },
    categories: {
      component: '.ct-categories-list-block ul:not(.placeholderify)',
      item: 'li.nav-item a',
    },
  },
  order: {
    card: {
      component: '.order-item:not(.placeholderify)',
      title: '.order-item__header-number a',
      price: '.order-item__header-price',
      state: '.order-item__header-state',
      lineItems: '.order-item__line-items',
    },
    page: {},
  },
  product: {
    catalog: '.commercetools-product-catalog',
    catalogNoProductsFound: '.no-products',
    cards: '.commercetools-product-cards:not(.placeholderify)',
    card: {
      component: 'figure.card:not(.placeholderify):not(.reloadify)',
      title: 'h2 a',
      price: 'span.price',
      addToCart: 'a.card-btn',
    },
    page: {
      component: 'article.product:not(.placeholderify)',
      title: 'h1',
      price: 'div.product-price',
      addToCart: '.add-to-cart-form .form-submit',
    },
  },
  cart: {
    component: 'form.commercetools-content-cart-form:not(.placeholderify)',
    lineItems: '.cart-line-items',
    emptyText: '.cart-empty-text',
  },
  stark: {
    pager: {
      component: '.pager__items',
      item: '.pager__item:not(.pager__item--next, .pager__item--prev, .pager__item--first, .pager__item--last) a',
    },
  },
  bootstrap: {
    pager: {
      component: 'ul.pagination',
      item: '.page-item:not(.page-item--next, .page-item--prev, .page-item--first, .page-item--last) a',
    },
  },
  page: {
    messages: 'div[data-drupal-messages]',
    messagesClose: '.btn-close',
  },
  placeholder: {
    active: '.placeholderify',
    inactive: ':not(.placeholderify)',
  },
};
