/**
 * Setup commercetools store.
 *
 * @param {object} browser
 *   Nightwatch browser instance.
 * @param {object} settings
 *   An object of settings necessary for the store setup page.
 */
module.exports = function storeSetup(browser, settings) {
  const fieldMapping = {
    language: 'edit-mapping-language-en',
    priceCurrency: 'edit-mapping-currency-en',
    priceCountry: 'edit-mapping-country-en',
    priceChannel: 'edit-mapping-channel-en',
    itemsPerPage: 'edit-items-per-page',
    unavailableDataText: 'edit-unavailable-data-text',
  };

  browser
    .thLogin('admin')
    .drupalRelativeURL('/admin/config/system/commercetools/store')
    .waitForElementVisible('body')
    .click('#edit-locale-settings summary')
    .perform(() => {
      Object.keys(settings).forEach((key) => {
        const value = settings[key];
        if (value) {
          const fieldId = fieldMapping[key];
          if (fieldId) {
            const selector = `#${fieldId}`;
            browser.setValue(selector, value);
          }
        }
      });
    })
    .click(
      'form.commercetools-store-settings-form .form-actions input[type="submit"]',
    )
    .waitForElementVisible('body')
    .thLogout();
};
