const { product, page } = require('../selectors');

/**
 * Add a product from the catalog page to the cart.
 *
 * @param {object} browser
 *   The Nightwatch browser instance.
 * @param {number} index
 *   The index of the product card. Optional.
 */
module.exports = function addCatalogProductToCart(browser, index = 0) {
  browser.perform(async () => {
    browser
      .click(
        browser
          .element({
            selector: product.card.component,
            index,
          })
          .findElement(product.card.title),
      )
      .waitForElementVisible(product.page.component)
      .click(
        browser
          .element({ selector: product.page.component })
          .findElement(product.page.addToCart),
      )
      .waitForElementVisible(page.messages)
      .assert.textContains(
        page.messages,
        'added to',
        'Verifying the "product added" message',
      );
  });
};
