module.exports = function checkBadCredentialsErrors(browser) {
  browser
    .navigateTo(browser.globals.ct.catalogUrl)
    .waitForElementVisible('.alert')
    .assert.elementPresent('.alert')
    .execute(
      function () {
        // Check for any commercetools-related error in the page body.
        const body = document.body.innerText;
        const errorPatterns = [
          'commercetools GraphQL error',
          'commercetools API operation failed',
          'Commercetools API responds with the access denied error',
          'invalid_client',
          'access denied',
        ];
        return errorPatterns.some((pattern) => body.includes(pattern));
      },
      [],
      function (result) {
        browser.assert.ok(
          result.value,
          'Page should contain a commercetools authentication error message',
        );
      },
    );
};
