const { placeholder } = require('../selectors');

/**
 * Checks if the placeholder is present and wait to disappear, if so.
 *
 * @param {object} browser
 *   Nightwatch browser instance.
 */
module.exports = function waitForPlaceholderToDisappear(browser) {
  browser.isPresent(
    {
      selector: placeholder.active,
      timeout: 1,
      suppressNotFoundErrors: true,
    },
    browser.waitForElementNotPresent(placeholder.active),
  );
};
