# commercetools Online Demo

A zero-click Drupal module that automatically configures a fully functional commercetools demo store with the B2C Lifestyle demo account. Perfect for testing, demonstrations, and exploring commercetools integration with Drupal.

## Overview

This module transforms a fresh Drupal installation into a ready-to-use commercetools demo store in seconds. Simply enable the module, and it automatically:

- Installs and configures all required dependencies
- Sets up the Bootstrap theme for a modern, responsive design
- Deploys commercetools B2C Lifestyle demo credentials
- Creates demo product catalog pages and components
- Configures the site with appropriate branding and settings

**No manual configuration required** - just enable and explore!

## Features

### Automatic Configuration

When you enable this module, it automatically configures:

- **Site Settings**: Sets site name to "commercetools Demo Store" with appropriate slogan
- **Themes**: Installs and activates Bootstrap 5 theme (frontend) and Claro (admin)
- **Admin Tools**: Installs Admin Toolbar for enhanced administration experience
- **commercetools Integration**: Deploys B2C Lifestyle demo account credentials
- **Demo Content**: Creates product catalog pages and demo components
- **Front Page**: Configures the homepage to showcase the demo catalog

### What's Included

#### Core Modules
- **commercetools**: Base integration with commercetools platform
- **commercetools_demo**: Demo content and configuration management
- **commercetools_content**: Server-side rendering of commercetools content
- **commercetools_decoupled**: Decoupled architecture support

#### Contrib Modules
- **Admin Toolbar**: Enhanced admin navigation and tools
- **Bootstrap 5 Theme**: Modern, responsive design (with fallback to Olivero)

#### Demo Content
- Pre-configured B2C Lifestyle demo account
- Product catalog browsing page
- Demo components for content display
- Ready-to-use navigation structure

## Installation

### Requirements

- Drupal 9, 10, or 11
- PHP 8.1 or higher
- commercetools account (demo credentials provided automatically)

### Method 1: Composer Installation (Recommended)

```bash
composer require commercetools/online-demo
drush en commercetools_online_demo -y
```

### Method 2: Manual Installation

1. Download or clone this module to `web/modules/custom/commercetools_online_demo/`
2. Enable the module:
   ```bash
   drush en commercetools_online_demo -y
   ```
   Or via the Drupal admin UI: **Extend** → Check "commercetools Online Demo" → **Install**

3. Wait for the installation to complete (30-60 seconds)
4. Visit your site's homepage to see the demo store

### Method 3: Drush Site Install

You can also install Drupal with this module in one command:

```bash
drush site-install standard --yes
drush en commercetools_online_demo -y
```

## simplytest.me Compatibility

This module is specifically designed to work with [simplytest.me](https://simplytest.me) for instant online demos. The module structure uses standard Drupal conventions that are fully compatible with simplytest.me's automated deployment system.

### Testing on simplytest.me

1. Visit [simplytest.me](https://simplytest.me)
2. Add the commercetools online demo module
3. Launch the demo
4. The site will be automatically configured and ready to explore

## What Gets Configured Automatically

### Site Configuration
- **Site name**: "commercetools Demo Store"
- **Site slogan**: "Powered by commercetools & Drupal"
- **Front page**: Set to demo product catalog

### Theme Configuration
- **Default theme**: Bootstrap 5 (responsive, modern design)
- **Admin theme**: Claro (clean admin interface)
- **Fallback**: Olivero theme if Bootstrap installation fails

### commercetools Configuration
- **Demo account**: B2C Lifestyle demo credentials
- **API connection**: Automatically configured with demo project
- **Demo components**: Product displays, catalog views
- **Demo pages**: Product catalog and browsing pages

### Module Configuration
- All required Drupal core modules enabled
- commercetools modules configured and ready
- Admin Toolbar installed for better admin experience
- Caches cleared to ensure fresh configuration

## Usage

After installation, you can:

1. **Browse the catalog**: Visit the homepage to see the product catalog
2. **Explore products**: Click on products to view details
3. **Admin interface**: Use the admin toolbar to manage content
4. **Customize**: Modify themes, layouts, and configurations as needed

### Accessing the Demo

- **Product Catalog**: Home page for demo showcase or `/commercetools-demo/content/catalog`
- **Admin Interface**: `/admin` (login with your Drupal admin account)
- **Content Management**: `/admin/content`

## Security Warning

⚠️ **IMPORTANT**: This module is designed for **demonstration and testing purposes only**.

- The module deploys **public demo credentials** for the commercetools B2C Lifestyle account
- These credentials are **publicly available** and intended for showcase purposes
- **DO NOT use this module in production** with real customer data
- **DO NOT use this module** for actual e-commerce operations
- For production use, configure your own commercetools project credentials

## Troubleshooting

### Bootstrap Theme Not Installing

If the Bootstrap theme fails to install, the module automatically falls back to the Olivero theme. You can manually install Bootstrap later:

```bash
composer require drupal/bootstrap5
drush en bootstrap5 -y
drush config-set system.theme default bootstrap5 -y
```

### Demo Content Not Appearing

If demo content doesn't appear after installation:

1. Clear all caches: `drush cr`
2. Check that commercetools modules are enabled: `drush pm:list --type=module --status=enabled | grep commercetools`
3. Verify the front page setting: `drush config-get system.site page.front`

### Admin Toolbar Not Available

The module attempts to install Admin Toolbar automatically. If it's not available in your codebase:

```bash
composer require drupal/admin_toolbar
drush en admin_toolbar -y
```

## License

This module is licensed under **GPL-2.0-or-later**, the same license as Drupal core.

See the [LICENSE](https://www.gnu.org/licenses/old-licenses/gpl-2.0.html) file for details.

## Credits

Developed for the commercetools Drupal integration project.

- **commercetools**: [https://commercetools.com](https://commercetools.com)
- **Drupal**: [https://www.drupal.org](https://www.drupal.org)

---

**Ready to explore?** Enable the module and visit your site's homepage to see commercetools in action! 🚀
