## commercetools Demo Online — Branch and Release Naming Convention

### Branches

- **2.x-stable**
  - Branch to deploy the latest stable version of the commercetools module.
  - Propagate here all commits from the `2.x` branch.
  - **Release names:** `2.N.M`
    - `N` is `0` for the first version and increases by `+1` for each significant change.
    - `M` is `0` for the initial release and increases by `+1` for minor changes.
    - **Example:** `2.0.0`

- **2.x-staging**
  - Branch to deploy the latest pre-release version of the commercetools module.
  - Propagate here all commits from the `2.x` branch.
  - **Release names:** `2.N.Z-rc1`
    - `Z` is the `M` value of the latest release plus `+1`.
    - **Example:** `2.0.1-rc1`
    - After each stable release, the `Z` value should be increased.

- **2.x**
  - Branch that installs the latest dev version of the module.
  - **Release names:** No releases; should work as the `2.x-dev` version branch in the Simplytest.me service.
