# Compare Role Permissions

## Introduction

The Compare Role Permissions module allows administrators to compare permissions between different user roles in Drupal 11. This tool helps identify differences in access levels and ensures proper permission configuration across your site.

## Features

- Compare permissions between any two roles
- Visual table showing permission differences
- Links to the permissions page for easy navigation
- Modern Drupal 11 implementation with proper dependency injection
- Comprehensive test coverage

## Requirements

- Drupal 10.x or 11.x
- PHP 8.1 or higher

## Installation

1. install module using composer
2. Enable the module through the admin interface at `/admin/modules` or via Drush:
   ```bash
   drush en compare_role_permissions
   ```
3. Grant the "Compare role permissions" permission to appropriate user roles at `/admin/people/permissions`

## Configuration

1. Navigate to **People > Permissions > Compare** (`/admin/people/permissions/compare`)
2. Select two different roles from the dropdown menus
3. Click **Compare** to view the differences

## Usage

The comparison tool will show:
- **Module**: The module providing each permission
- **Permission**: The human-readable permission name
- **Role 1**: Whether the first selected role has this permission (Yes/No)
- **Role 2**: Whether the second selected role has this permission (Yes/No)

Only permissions that differ between the two roles are displayed. If both roles have identical permissions, you'll see a message indicating this.

## Technical Details

### Architecture

This module follows modern Drupal development practices:

- **Object-oriented form**: Uses `FormBase` instead of procedural functions
- **Dependency injection**: Properly injects required services
- **Entity API**: Uses Role entities instead of direct database queries
- **Routing system**: Uses YAML routing configuration
- **Permissions**: Uses YAML permissions configuration
- **Render arrays**: Uses modern rendering system

### Services Used

- `entity_type.manager`: For loading role entities
- `renderer`: For rendering form elements
- `user.permissions`: For retrieving permission information

### Testing

The module includes comprehensive PHPUnit tests:

- **Functional tests**: Testing form access, validation, and submission
- **Unit tests**: Testing individual methods and validation logic

Run tests with:
```bash
phpunit web/modules/custom/compare_role_permissions/tests/
```

## Development

### File Structure

```
compare_role_permissions/
├── compare_role_permissions.info.yml      # Module metadata
├── compare_role_permissions.module        # Hook implementations
├── compare_role_permissions.routing.yml   # Route definitions
├── compare_role_permissions.permissions.yml # Permission definitions
├── src/
│   └── Form/
│       └── CompareRolePermissionsForm.php # Main form class
├── tests/
│   └── src/
│       ├── Functional/
│       │   └── CompareRolePermissionsFunctionalTest.php
│       └── Unit/
│           └── CompareRolePermissionsFormTest.php
└── README.md
```

### API Changes from Drupal 7

This module has been completely rewritten for Drupal 11:

- **Info file**: Converted from `.info` to `.info.yml`
- **Routing**: Replaced `hook_menu()` with routing YAML
- **Forms**: Converted procedural functions to FormBase class
- **Database**: Replaced `db_select()` with Entity API
- **Permissions**: Converted `hook_permission()` to permissions YAML
- **Theming**: Replaced `theme()` with render arrays
- **Help**: Updated `hook_help()` for new route system

## Maintainers

Current maintainers:
- visabhishek - https://www.drupal.org/user/896554
- sriharshauppuluri - https://www.drupal.org/user/1211580

## Contributing

Bug reports and feature requests should be submitted through the issue queue.

## License

This project is licensed under the GPL-2.0+ license.
