<?php

namespace Drupal\compiler_scss\Element;

use Drupal\Core\Render\Element\FormElementBase;

/**
 * A form element to represent null-able Sass colors.
 *
 * Copyright (C) 2025  Library Solutions, LLC (et al.).
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * @FormElement("compiler_scss_color")
 */
class Color extends FormElementBase {

  /**
   * {@inheritdoc}
   */
  public function getInfo() {
    return [
      '#children' => [],
      '#element_validate' => [[static::class, 'validateColor']],
      '#input' => TRUE,
      '#required' => FALSE,
      '#theme' => 'container',
      '#theme_wrappers' => ['form_element'],
      '#title' => NULL,
      '#tree' => TRUE,
      '#process' => [[static::class, 'processColor']],
    ];
  }

}
