<?php

namespace Drupal\compiler_scss\Element;

use Drupal\Core\Render\Element\FormElementBase;

/**
 * A form element to represent single-unit Sass numbers.
 *
 * Copyright (C) 2025  Library Solutions, LLC (et al.).
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * @FormElement("compiler_scss_number")
 */
class Number extends FormElementBase {

  /**
   * {@inheritdoc}
   */
  public function getInfo() {
    return [
      '#children' => [],
      '#element_validate' => [[static::class, 'validateNumber']],
      '#input' => TRUE,
      '#max' => NULL,
      '#min' => NULL,
      '#placeholder' => NULL,
      '#process' => [[static::class, 'processNumber']],
      '#required' => FALSE,
      '#step' => NULL,
      '#theme' => 'container',
      '#theme_wrappers' => ['form_element'],
      '#title' => NULL,
      '#tree' => TRUE,
      '#units' => NULL,
      '#attributes' => [
        'class' => [
          'container-inline',
        ],
      ],
    ];
  }

}
