<?php

declare(strict_types=1);

namespace Drupal\complete_webform_exporter\Hook;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Url;

/**
 * Hook implementations for complete_webform_exporter.
 */
class CompleteWebformExporterHooks {

  use StringTranslationTrait;

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function help($route_name, RouteMatchInterface $route_match): ?string {
    if ($route_name == 'help.page.complete_webform_exporter') {
      $output = '<h3>' . $this->t('About') . '</h3>';
      $output .= '<p>' . $this->t('Complete WebForm Exporter is designed to make exporting webform submissions incredibly easy for users. Here is how it helps:') . '</p>';
      $output .= '<ul>';
      $output .= '<li>' . $this->t('Single-Click Export: Users can export their webform submissions effortlessly with just one click.') . '</li>';
      $output .= '<li>' . $this->t('Bulk Submission Download: It allows users to select and download multiple submissions at once, saving time and effort.') . '</li>';
      $output .= '<li>' . $this->t('Individual Submission Download: Users can also choose to download each submission separately, providing flexibility.') . '</li>';
      $output .= '<li>' . $this->t('Includes Attachments: All attachments submitted with the webform are included in the export, ensuring no information is missed.') . '</li>';
      $output .= '<li>' . $this->t('Comprehensive Zip File: The exported submissions, along with attachments and submitted information, are neatly packaged into a single zip file for convenience.') . '</li>';
      $output .= '</ul>';
      return $output;
    }
    return NULL;
  }

  /**
   * Implements hook_entity_operation().
   */
  #[Hook('entity_operation')]
  public function entityOperation(EntityInterface $entity): array {
    $operations = [];

    if ($entity->getEntityTypeId() == 'webform_submission') {
      $operations['export_submission'] = [
        'title' => $this->t('Export submission'),
        'url' => Url::fromRoute('complete_webform_exporter.export_submission', [
          'webform_id' => $entity->webform_id->target_id,
          'submission_id' => $entity->id(),
        ]),
        'weight' => 50,
      ];
    }

    return $operations;
  }

}
