/**
 * @file
 * Javascript functionality for component accordion.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentBubbleMap = Drupal.componentBubbleMap || {};
  Drupal.behaviors.componentBubbleMap = {
    attach: function (context) {
      Drupal.componentBubbleMap.addClassForCountItem();
      Drupal.componentBubbleMap.circleItem(context);
    }
  }
  Drupal.componentBubbleMap.addClassForCountItem = function () {
    const $component_wrapper = $('.component-builder.component-wrapper.component-wrapper--type-bubble_map');
    var count = $(once('countItem', ".field--name-field-bubble-map")).children().length;
    $(once('addClassCountItem', $component_wrapper)).addClass('item-count-display--bubble-map-' + count);
  };
  Drupal.componentBubbleMap.circleItem = function (context) {
    const $bubble_map = $(once('bubbleMap', '.preview .component-builder.component-wrapper.component-wrapper--type-bubble_map, .component-builder.component-wrapper.component-wrapper--type-bubble_map:not(.component-builder-preview)', context));
    if ($bubble_map.length > 0) {
      $bubble_map.each(function () {
        const $this = $(this);
        const $component_wrapper_content = $this.find('.component-wrapper--content');
        let width = 0;
        let height = 0;
        if ($component_wrapper_content.length > 0) {
          width = $this.width();
          height = $this.height();
        }
        let $main_content_wrapper = $(once('getElement', this)).find('.main-wrapper-bubble-map');
        var x = $main_content_wrapper.wrap('<p/>').parent().html();
        $main_content_wrapper.unwrap();
        $(once('hideDefaultContent', $main_content_wrapper)).css('display', 'none');
        let $field_bubble_map = $this.find('.field--name-field-bubble-map');
        if ($field_bubble_map.length > 0) {
          $field_bubble_map.each(function () {
            $(once('addElementMarkup', this)).prepend(x);
          });
        }
        $field_bubble_map = $this.find('.field--name-field-bubble-map');
        if ($field_bubble_map.length > 0) {
          $field_bubble_map.each(function () {
            $(this).incircle({
              'left': width / 4 + "px",
              'top': height / 4 + "px",
            });
          });
        }
      })
    }
  }

})(jQuery, Drupal, once);
