/**
 * @file
 * Javascript functionality for component carousel.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentButtons = Drupal.componentButtons || {};
  Drupal.behaviors.buttons = {
    attach: function (context) {
      Drupal.componentButtons.handleLinkType();
    }
  }

  Drupal.componentButtons.handleLinkType = function () {
    const $field_button_link = $(".field--name-field-button-link");
    if ($field_button_link.length) {
      $field_button_link.each(function () {
        let type = $(this).attr('link-type');
        if (type === "video") {
          const $a_tag = $(this).find("a");
          if ($a_tag.length) {
            $a_tag.each(function () {
              let text = $(this).text().trim();
              $(once('editMarkup', this)).html("<span class = 'text-link'>" + text + "</span>");
              let markup_icon = '<span class = "video-icon"></span>';
              $(once('addLink', '.text-link', this)).before(markup_icon);
              $(this).magnificPopup({
                preloader: false,
                type:'iframe',
                tClose: 'X',
                iframe: {
                  markup: '<div class="mfp-iframe-scaler">'+
                      '<div class="mfp-close"></div>'+
                      '<iframe class="mfp-iframe" frameborder="0" allowfullscreen></iframe>'+
                      '</div>',
                },
                closeBtnInside: true,
                closeOnBgClick: false,
                fixedBgPos: false,
              });
            });
          }
        }
      });
    }
  };

})(jQuery, Drupal, once);
