/**
 * @file
 * Javascript functionality for component carousel.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentCarousel = Drupal.componentCarousel || {};
  Drupal.behaviors.carousel = {
    attach: function (context) {
      Drupal.componentCarousel.carouselImages(context);
      Drupal.componentCarousel.carouselHiddenFields();
      Drupal.componentCarousel.carousel(context);
    }
  }

  Drupal.componentCarousel.carouselImages = function (context) {
    var $carousels = $(once('wrapperCarousel', '.preview .component-builder.component-wrapper--type-carousel, .component-builder.component-wrapper--type-carousel:not(.component-builder-preview)', context));
    let showDot = false;
    if ($carousels.length > 0) {
      $carousels.each(function () {
        var $this = $(this);
        const number = $this.attr('data-carousel-columns') || 2;
        const dot = $this.attr('data-show-dot');
        if (dot == 'true') {
          showDot = true;
        } else if (dot == 'false') {
          showDot = false;
        } else {
          showDot = false;
        }
        var $items = $this.find('.component-wrapper--content > .field--name-field-carousel.field__items');
        Drupal.componentCarousel.carouselImageSlide($items, number, showDot);
      })
    }
  }

  Drupal.componentCarousel.carouselImageSlide = function ($selector, numberShow = 2, showDot = false) {
    if ($selector.length > 0) {
      if ($selector.find('.field__item').length <= numberShow) {
        showDot = false;
      }
      $selector.not('.slick-initialized').slick({
        dots: showDot,
        rtl: drupalSettings['components']['carousel']['rtl'],
        infinite: true,
        speed: 300,
        slidesToShow: numberShow,
        slidesToScroll: 1,
        responsive: [
          {
            breakpoint: 1024,
            settings: {
              slidesToShow: numberShow,
              slidesToScroll: 2,
              infinite: true,
              dots: showDot
            }
          },
          {
            breakpoint: 768,
            settings: {
              slidesToShow: 1,
              slidesToScroll: 1
            }
          },
          {
            breakpoint: 480,
            settings: {
              slidesToShow: 1,
              slidesToScroll: 1
            }
          }
        ]
      });
    }
  }

  Drupal.componentCarousel.carouselHiddenFields = function (context) {
    var $carouselItems = $(once('hiddenFields', '.component-builder.component-wrapper--type-carousel', context));
    if ($carouselItems.length > 0) {
      $carouselItems.each(function () {
        var $this = $(this);
        var $hidden_fields = $this.attr('data-hidden-field') || "";
        if ($hidden_fields) {
          $hidden_fields = JSON.parse($hidden_fields);
          $($this.find('.slick-slide')).each(function () {
            for (let i = 0; i < $hidden_fields.length; i++) {
              $(this).find('.field--name-' + $hidden_fields[i].replace("_", "-")).each(function () {
                $(this).css("display", "none");
              });
            }
          });
        }
      })
    }
  }

  Drupal.componentCarousel.carousel = function (context) {
    const $carousel =  $(once('carouselItems', '.component-builder.component-item--type-carousel', context));
    if ($carousel.length > 0) {
      $carousel.each(function () {
        const $this = $(this);
        $('.component-item--type-carousel .field--name-title').matchHeight({});
        $('.component-item--type-carousel .field--name-field-description').matchHeight({});
      })
    }
  }

})(jQuery, Drupal, once);
