/**
 * @file
 * Javascript functionality for component divider section.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentDividerSection = Drupal.componentDividerSection || {};
  Drupal.behaviors.dividersection = {
    attach: function (context) {
      Drupal.componentDividerSection.dividerSection(context);
    }
  }
  Drupal.componentDividerSection.dividerSection = function (context) {
    const $dividerSection =  $(once('divider-sectionItems', '.component-builder.component-item--type-divider-section', context));
    if ($dividerSection.length > 0) {
      if($('.component-item--type-divider-section .component-item--content').length > 0 ) {
        $('.component-item--type-divider-section .component-item--content ').matchHeight({});
        if($('.component-item--type-divider-section .field--name-field-divider-section-desc').length > 0 ) {
          $('.component-item--type-divider-section .field--name-field-divider-section-desc').matchHeight({});
        }
        if($('.component-item--type-divider-section .field--name-title').length > 0 ) {
          $('.component-item--type-divider-section .field--name-title').matchHeight({});
        }
      }
    }
  }

})(jQuery, Drupal, once);
