/**
 * @file
 * Javascript functionality for component video and text.
 */

(function ($, Drupal, once) {

  'use strict';

  Drupal.componentVideoAndText = Drupal.componentVideoAndText || {};
  Drupal.behaviors.videoAndText = {
    attach: function (context) {
      Drupal.componentVideoAndText.addButtonForVideo();
      Drupal.componentVideoAndText.handleClickVideo();
    }
  }

  Drupal.componentVideoAndText.addButtonForVideo = function () {
    const $component_item = $('.component-builder.component-item.component-item--type-video-and-text');
    if ($component_item.length > 0) {
      $component_item.each(function () {
        let $field_group_text = $component_item.find('.group-video-text');
        let $markupButton = '<button class = "video-button stop"></button>'
        if ($field_group_text.length > 0) {
          $(once('addMarkupItem', $field_group_text)).prepend($markupButton);
        }
      });
    }
  }

  Drupal.componentVideoAndText.handleClickVideo = function () {
    const $component_item = $(".component-builder.component-item.component-item--type-video-and-text");
    if ($component_item.length > 0) {
      $component_item.each(function () {
        let $component_item = $(this);
        let $video = $component_item.find("video.video--field-vat-video");
        if ($video.length > 0) {
          $video.each(function () {
            $(once('click', this)).on('click', function () {
              let $videoSelector = $(this);
              let $button = $component_item.find('button.video-button');
              if ($button.length > 0) {
                $button.each(function () {
                  $(once("toggleClassStop", this)).toggleClass('stop');
                  $(once("toggleClassPlay", this)).toggleClass('play');
                });
              }
              let $text_wrapper = $component_item.find('div.group-text');
              if ($text_wrapper.length > 0) {
                $text_wrapper.each(function () {
                  if ($(this).css('display') === 'none') {
                    $(once('displayBlockText', this)).css('display', 'block');
                    // $videoSelector.removeAttr("controls").once('removeAttribute');
                    $videoSelector.trigger("pause");
                  }
                  else if ($(this).css('display') === 'block') {
                    $(once('displayNoneText', this)).css('display', 'none');
                    // $videoSelector.attr('controls', '').once('controlShow');
                    $videoSelector.trigger("play");
                  }
                });
              }
            });
          });
        }

        let $button = $component_item.find("button.video-button");
        if ($button.length > 0) {
          $button.each(function () {
            $(once('clickButton', this)).click(function () {
              $(once("toggleClassStop", this)).toggleClass('stop');
              $(once("toggleClassPlay", this)).toggleClass('play');

              if ($video.length > 0) {
                $video.each(function () {
                    $(this).trigger("play");
                  // }
                });
              }

              let $text_wrapper = $component_item.find('div.group-text');
              if ($text_wrapper.length > 0) {
                $text_wrapper.each(function () {
                  if ($(this).css('display') === 'none') {
                    $(once('displayBlockText', this)).css('display', 'block');
                  }
                  else if ($(this).css('display') === 'block') {
                    $(once('displayNoneText', this)).css('display', 'none');
                  }
                });
              }
            })
          });
        }

      });
    }
  };

})(jQuery, Drupal, once);
