/**
 * This src code is used to implement helper functions.
 */
(function ($) {
  'use strict';

  $.addMatchHeight = function (parentSelector, childrenSelector) {
    const $parent = $(parentSelector);
    if ($parent.length > 0) {
      $parent.each(function () {
        let children = $(this).find(childrenSelector);
        if (children.length > 0) {
          let maxHeight = 0;
          children.each(function () {
            if ($(this).outerHeight() > maxHeight) {
              maxHeight = $(this).outerHeight();
            }
          });
          if (maxHeight > 0) {
            children.each(function () {
              $(this).css({'min-height': maxHeight + 'px'});
            });
          }
        }
      });
    }
  }
}(jQuery));
