<?php

namespace Drupal\component_builder_toolbar;

use Drupal\component_builder\Entity\ComponentWrapperInterface;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Url;

/**
 * Defines interface for a service that has all needed functions for toolbar.
 */
interface ToolbarManagerInterface {

  /**
   * Check if current page and current user can see toolbar.
   *
   * @return array|bool
   *   The calculated values.
   */
  public function accessToolbar($return_info = FALSE, $route_suffix = 'component_builder_toolbar');

  /**
   * Move wrapper to other region or update wrapper delta.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity for move wrapper.
   * @param \Drupal\component_builder\Entity\ComponentWrapperInterface $component_wrapper
   *   The component_wrapper was moved.
   * @param string $field_name
   *   The field name.
   * @param string $from_region
   *   The old region.
   * @param int $from
   *   The old index.
   * @param string $to_region
   *   The new region.
   * @param int $to
   *   The new index.
   *
   * @return bool
   *   TRUE if the component was moved, FALSE otherwise.
   */
  public function moveWrapper(EntityInterface $entity, ComponentWrapperInterface $component_wrapper, string $field_name, string $from_region, int $from, string $to_region, int $to);

  /**
   * Build markup for wrapper.
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity for build component wrapper markup.
   * @param \Drupal\component_builder\Entity\ComponentWrapperInterface $component_wrapper
   *   The component wrapper.
   * @param \Drupal\Core\Url|null $move_wrapper_url
   *   The move url to call api.
   * @param int $delta
   *   The delta.
   *
   * @return array
   *   An array markup of component wrapper.
   */
  public function buildComponentWrapperMarkup(EntityInterface $entity, ComponentWrapperInterface $component_wrapper, Url $move_wrapper_url = NULL, int $delta = 0);

}
