<?php

namespace Drupal\component_builder;

use Drupal\component_builder\Entity\ComponentItemType;
use Drupal\Core\Entity\EntityInterface;
use Drupal\entity\BulkFormEntityListBuilder;

/**
 * Defines the list builder for products.
 */
class ComponentItemListBuilder extends BulkFormEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['title'] = $this->t('Title');
    $header['type'] = $this->t('Type');
    $header['status'] = $this->t('Status');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /** @var \Drupal\component_builder\Entity\ComponentItemTypeInterface $item_type */
    $item_type = ComponentItemType::load($entity->bundle());
    if (!$item_type) {
      $entity->delete();
    }

    $row['title']['data'] = [
      '#type' => 'link',
      '#title' => $entity->label(),
      '#url' => $entity->toUrl(),
    ];

    $row['type'] = [
      '#markup' => $item_type ? $item_type->label() : '',
    ];

    $row['status'] = [
      '#markup' => $entity->isPublished() ? $this->t('published') : $this->t('not published'),
    ];

    return $row + parent::buildRow($entity);
  }

}
