<?php

namespace Drupal\component_builder\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\inline_entity_form\Form\EntityInlineForm;

/**
 * Defines the inline form for order items.
 */
class ComponentItemInlineForm extends EntityInlineForm {

  /**
   * {@inheritdoc}
   */
  public function entityForm(array $entity_form, FormStateInterface $form_state) {
    $entity_form = parent::entityForm($entity_form, $form_state);
    $entity_form['admin_title']['#attributes']['class'][] = 'visually-hidden';
    $entity_form['status']['#attributes']['class'][] = 'visually-hidden';
    return $entity_form;
  }

}
