<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Buttons' component.
 *
 * @ComponentBuilder(
 *   id = "buttons",
 *   label = @Translation("Buttons"),
 *   group = @Translation("Site Function"),
 *   category = @Translation("Site Function"),
 *   template = "buttons"
 * )
 */
class Buttons extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_buttons/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_buttons/assets/style.js' => [],
        'components/component_buttons/assets/magnific-popup.min.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
