<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Categories' component.
 *
 * @ComponentBuilder(
 *   id = "categories",
 *   label = @Translation("Categories"),
 *   group = @Translation("Site Function"),
 *   category = @Translation("Site Function"),
 *   template = "categories"
 * )
 */
class Categories extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_categories/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_categories/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
