<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;

/**
 * Provides 'Classified Ads' component.
 *
 * @ComponentBuilder(
 *   id = "classified_ads",
 *   label = @Translation("Classified Ads"),
 *   group = @Translation("Grid Style"),
 *   category = @Translation("Grid Style"),
 *   template = "classified_ads",
 * )
 */
class ClassifiedAds extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_classified_ads/assets/style.css' => [],
        ],
      ],
      "version" => "VERSION",
    ];
  }

}
