<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;
use Drupal\Core\Render\Element;

/**
 * Provides 'Food Menu' component.
 *
 * @ComponentBuilder(
 *   id = "food_menu",
 *   label = @Translation("Food Menu"),
 *   group = @Translation("Listing"),
 *   category = @Translation("Listing"),
 *   template = "food_menu",
 *   single_value = TRUE,
 *   alter_wrapper = TRUE
 * )
 */
class FoodMenu extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function prepareVariables(array &$variables) {
    if (isset($variables['elements']['#component_wrapper'])) {
      if (isset($variables['content']['field_image']) && $variables['content']['field_image']) {
        foreach (Element::children($variables['content']['field_image']) as $key) {
          $variables['images'][] = $variables['content']['field_image'][$key];
        }
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_food_menu/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_food_menu/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
