<?php

namespace Drupal\component_builder\Plugin\ComponentBuilder;

use Drupal\component_builder\ComponentBuilderBase;
use Drupal\Core\Render\Element;

/**
 * Provides 'Highlight Content' component.
 *
 * @ComponentBuilder(
 *   id = "highlight_content",
 *   label = @Translation("Highlight Content"),
 *   group = @Translation("Content style (paragraph style)"),
 *   category = @Translation("Content style (paragraph style)"),
 *   template = "highlight_content",
 *   single_value = TRUE,
 *   alter_wrapper = TRUE
 * )
 */
class HighlightContent extends ComponentBuilderBase {

  /**
   * {@inheritdoc}
   */
  public function getTemplatePath() {
    return $this->getComponentPath() . '/templates';
  }

  /**
   * {@inheritdoc}
   */
  public function prepareVariables(array &$variables) {
    if (isset($variables['elements']['#component_wrapper'])) {
      foreach (Element::children($variables['content']['field_highlight_content']) as $key) {
        $variables['articles'][] = $variables['content']['field_highlight_content'][$key]['#component_item'];
      }
    }
  }

  /**
   * {@inheritdoc}
   */
  public function getLibraries() {
    return [
      'css' => [
        'theme' => [
          'components/component_highlight_content/assets/style.css' => [],
        ],
      ],
      'js' => [
        'components/component_highlight_content/assets/style.js' => [],
      ],
      'dependencies' => [
        'core/drupal',
        'core/jquery',
        'core/jquery.once',
      ],
      "version" => "VERSION",
    ];
  }

}
